<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\V1\AuthController;
use App\Http\Controllers\API\V1\AuthPasswordController;
use App\Http\Controllers\API\V1\DashboardController;
use App\Http\Controllers\API\V1\LeadController;
use App\Http\Controllers\API\V1\FollowUpController;
use App\Http\Controllers\API\V1\NotificationController;
use App\Http\Controllers\API\V1\CalendarController;
use App\Http\Controllers\API\V1\SubscriptionController;
use App\Http\Controllers\API\V1\SettingsController;
use App\Http\Controllers\API\V1\TrialController;

/*
|--------------------------------------------------------------------------
| API Routes (Versioned)
|--------------------------------------------------------------------------
| Base URL: /api/v1
| Auth: Laravel Sanctum
|--------------------------------------------------------------------------
*/

Route::prefix('v1')->group(function () {

    /* ================= AUTH (PUBLIC) ================= */

    Route::post('/auth/login',    [AuthController::class, 'login']);
    Route::post('/auth/register', [AuthController::class, 'register']);
    Route::post('/auth/request-otp', [AuthController::class, 'requestOtp']);
    Route::post('/auth/verify-otp', [AuthController::class, 'verifyOtp']);
    Route::post('/auth/login', [AuthController::class, 'login']);
    Route::post('/auth/logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');

    // ✅ Password reset
    Route::post('/auth/forgot-password', [AuthPasswordController::class, 'forgotPassword']);
    Route::post('/auth/reset-password', [AuthPasswordController::class, 'resetPassword']);

    /* ================= AUTHENTICATED ROUTES ================= */

    Route::middleware('auth:sanctum')->group(function () {

        /* -------- AUTH -------- */
        Route::post('/auth/logout', [AuthController::class, 'logout']);
        Route::get('/auth/me',      [AuthController::class, 'me']);

        /* -------- DASHBOARD -------- */
        Route::get('/dashboard/summary', [DashboardController::class, 'summary']);

        /* -------- LEADS -------- */
        Route::get('/leads',              [LeadController::class, 'index']);
        Route::post('/leads',             [LeadController::class, 'store']);
        Route::get('/leads/{lead}',       [LeadController::class, 'show']);
        Route::put('/leads/{lead}',       [LeadController::class, 'update']);
        Route::delete('/leads/{lead}',    [LeadController::class, 'destroy']);

        /* -------- FOLLOW UPS -------- */
        Route::get('/follow-ups/today',       [FollowUpController::class, 'today']);
        Route::get('/follow-ups/upcoming',    [FollowUpController::class, 'upcoming']);
        Route::get('/follow-ups/overdue',  [FollowUpController::class, 'overdue']);
        Route::get('/follow-ups/overdue/count', [FollowUpController::class, 'overdueCount']);
        Route::post('/follow-ups',            [FollowUpController::class, 'store']);

        Route::patch('/follow-ups/{followUp}/done',        [FollowUpController::class, 'markDone']);
        Route::patch('/follow-ups/{followUp}/skip',        [FollowUpController::class, 'skip']);
        Route::patch('/follow-ups/{followUp}/reschedule',  [FollowUpController::class, 'reschedule']);
        Route::patch('/follow-ups/{followUp}/snooze',      [FollowUpController::class, 'snooze']);

        /* -------- NOTIFICATIONS -------- */
        Route::get('/notifications',                        [NotificationController::class, 'index']);
        Route::patch('/notifications/{notification}/read',   [NotificationController::class, 'markRead']);

        /* =====================================================
         | PRO / TRIAL ROUTES (LOCKED AT API LEVEL)
         ===================================================== */
        Route::middleware('pro_or_trial')->group(function () {

            /* -------- CALENDAR -------- */
            Route::post('/calendar/connect', [CalendarController::class, 'connect']);
            Route::get('/calendar/events',   [CalendarController::class, 'events']);

            /* -------- ANALYTICS (future safe) -------- */
            // Route::get('/analytics', [AnalyticsController::class, 'index']);
        });

        /* -------- TRIAL -------- */
        Route::post('/trial/start', [TrialController::class, 'start']);

        /* -------- SUBSCRIPTION -------- */
        Route::get('/subscription',          [SubscriptionController::class, 'show']);
        Route::post('/subscription/cancel',  [SubscriptionController::class, 'cancel']);

        /* -------- SETTINGS -------- */
        Route::get('/settings/profile',           [SettingsController::class, 'profile']);
        Route::put('/settings/profile',           [SettingsController::class, 'updateProfile']);
        Route::put('/settings/notifications',     [SettingsController::class, 'updateNotifications']);
    });
});
