<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')
                  ->constrained()
                  ->cascadeOnDelete();

            $table->enum('provider', ['razorpay', 'stripe']);
            $table->string('provider_subscription_id', 191);

            $table->string('plan', 50);
            $table->enum('status', [
                'trial',
                'active',
                'cancelled',
                'expired'
            ])->default('trial');

            $table->timestamp('trial_ends_at')->nullable();
            $table->timestamp('current_period_end')->nullable();

            $table->timestamps();

            // Indexes
            $table->index('user_id');
            $table->index('provider');
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};

