<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('follow_ups', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')
                  ->constrained()
                  ->cascadeOnDelete();

            $table->foreignId('lead_id')
                  ->constrained()
                  ->cascadeOnDelete();

            $table->timestamp('scheduled_at');
            $table->timestamp('completed_at')->nullable();

            $table->enum('type', [
                'call',
                'email',
                'meeting',
                'custom'
            ])->default('call');

            $table->enum('status', [
                'pending',
                'done',
                'skipped'
            ])->default('pending');

            $table->text('notes')->nullable();

            $table->timestamps();

            // Indexes
            $table->index('user_id');
            $table->index('lead_id');
            $table->index('status');
            $table->index('scheduled_at');
            $table->index(['user_id', 'scheduled_at']);
            $table->index(['lead_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('follow_ups');
    }
};

