<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')
                  ->constrained()
                  ->cascadeOnDelete();

            $table->string('name', 150);
            $table->string('email', 191)->nullable();
            $table->string('phone', 30)->nullable();

            $table->decimal('deal_value', 12, 2)->nullable();
            $table->char('currency', 3)->default('INR');

            $table->enum('status', [
                'new',
                'contacted',
                'follow_up',
                'won',
                'lost'
            ])->default('new');

            $table->timestamp('last_follow_up_at')->nullable();
            $table->timestamp('next_follow_up_at')->nullable();

            $table->string('source', 100)->nullable();
            $table->text('notes')->nullable();

            $table->timestamps();

            // Indexes
            $table->index('user_id');
            $table->index('status');
            $table->index('next_follow_up_at');
            $table->index('last_follow_up_at');
            $table->index(['user_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};

