<?php

namespace App\Services\Notification;

use App\Models\User;
use App\Models\Notification;

class NotificationService
{
    public function notify(
        User $user,
        string $type,
        string $title,
        string $body
    ): Notification {
        return $user->userNotifications()->create([
            'type'  => $type,
            'title' => $title,
            'body'  => $body,
            'sent_at' => now(),
        ]);
    }
}
