<?php

namespace App\Services\Lead;

use App\Models\Lead;
use App\Models\User;

class LeadService
{
    /**
     * Create a lead
     */
    public function create(User $user, array $data): Lead
    {
        return $user->leads()->create($data);
    }

    /**
     * Update a lead
     */
    public function update(Lead $lead, array $data): Lead
    {
        $lead->update($data);
        return $lead;
    }

    /**
     * Delete a lead
     */
    public function delete(Lead $lead): void
    {
        $lead->delete();
    }

    /**
     * Update next follow-up timestamp
     */
    public function updateNextFollowUp(Lead $lead): void
    {
        $next = $lead->followUps()
            ->where('status', 'pending')
            ->orderBy('scheduled_at')
            ->first();

        $lead->update([
            'next_follow_up_at' => $next?->scheduled_at,
            'last_follow_up_at' => now(),
        ]);
    }
}
