<?php

namespace App\Services\Dashboard;

use App\Models\User;
use App\Models\FollowUp;
use App\Models\Lead;

class DashboardService
{
    public function summary(User $user): array
    {
        return [
            'today_followups' => FollowUp::where('user_id', $user->id)
                ->today()
                ->count(),

            'overdue_followups' => FollowUp::where('user_id', $user->id)
                ->overdue()
                ->count(),

            'active_leads' => Lead::where('user_id', $user->id)
                ->active()
                ->count(),

            'streak_days' => 0 // later enhancement
        ];
    }
}
