<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;
use App\Models\Lead;
use App\Models\FollowUp;
use App\Policies\LeadPolicy;
use App\Policies\FollowUpPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        Lead::class     => LeadPolicy::class,
        FollowUp::class => FollowUpPolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        //
    }
}
