<?php

namespace App\Policies;

use App\Models\Lead;
use App\Models\User;

class LeadPolicy
{
    /**
     * View a lead
     */
    public function view(User $user, Lead $lead): bool
    {
        return $lead->user_id === $user->id;
    }

    /**
     * Update a lead
     */
    public function update(User $user, Lead $lead): bool
    {
        return $lead->user_id === $user->id;
    }

    /**
     * Delete a lead
     */
    public function delete(User $user, Lead $lead): bool
    {
        return $lead->user_id === $user->id;
    }
}
