<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Lead extends Model
{
    protected $fillable = [
        'user_id',
        'name',
        'email',
        'phone',
        'deal_value',
        'currency',
        'status',
        'last_follow_up_at',
        'next_follow_up_at',
        'source',
        'notes',
    ];

    protected $casts = [
        'deal_value' => 'decimal:2',
        'last_follow_up_at' => 'datetime',
        'next_follow_up_at' => 'datetime',
    ];

    /* ================= RELATIONSHIPS ================= */

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function followUps(): HasMany
    {
        return $this->hasMany(FollowUp::class);
    }

    /* ================= SCOPES ================= */

    public function scopeActive($query)
    {
        return $query->whereNotIn('status', ['won', 'lost']);
    }

    public function scopeOverdue($query)
    {
        return $query->whereNotNull('next_follow_up_at')
                     ->where('next_follow_up_at', '<', now());
    }
}
