<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Carbon\Carbon;

class FollowUp extends Model
{
    protected $fillable = [
        'user_id',
        'lead_id',
        'scheduled_at',
        'completed_at',
        'type',
        'status',
        'notes',
    ];

    protected $casts = [
        'scheduled_at' => 'datetime',
        'completed_at' => 'datetime',
    ];

    /* ================= RELATIONSHIPS ================= */

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function lead(): BelongsTo
    {
        return $this->belongsTo(Lead::class);
    }

    /* ================= SCOPES ================= */

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    // public function scopeToday($query)
    // {
    //    // return $query->whereDate('scheduled_at', Carbon::today());
    //     return $query->whereRaw('DATE(scheduled_at) = CURDATE()');
    // }
    public function scopeToday($query)
    {
        return $query->whereBetween('scheduled_at', [
            now()->startOfDay(),
            now()->endOfDay(),
        ]);
    }

    public function scopeOverdue($query)
    {
        return $query->where('status', 'pending')
                     ->where('scheduled_at', '<', now());
    }

    public function scopeUpcoming($query)
    {
        return $query->where('scheduled_at', '>', now())
                    ->orderBy('scheduled_at');
    }
}
