<?php

namespace App\Jobs;

use App\Models\FollowUp;
use App\Services\Notification\NotificationService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DailyFollowUpReminderJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(NotificationService $notificationService): void
    {
        FollowUp::with('user')
            ->whereDate('scheduled_at', today())
            ->where('status', 'pending')
            ->chunkById(100, function ($followUps) use ($notificationService) {
                foreach ($followUps as $followUp) {
                    $notificationService->notify(
                        $followUp->user,
                        'follow_up_today',
                        'Follow-up Reminder',
                        'You have a follow-up scheduled today.'
                    );
                }
            });
    }
}
