<?php

namespace App\Http\Requests\Lead;

use Illuminate\Foundation\Http\FormRequest;

class UpdateLeadRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name'       => 'sometimes|string|max:150',
            'email'      => 'sometimes|nullable|email',
            'phone'      => 'sometimes|nullable|string|max:30',
            'status'     => 'sometimes|in:new,contacted,follow_up,won,lost',
            'deal_value' => 'sometimes|nullable|numeric|min:0',
            'notes'      => 'sometimes|nullable|string'
        ];
    }
}
