<?php

namespace App\Http\Requests\Lead;

use Illuminate\Foundation\Http\FormRequest;

class StoreLeadRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name'       => 'required|string|max:150',
            'email'      => 'nullable|email',
            'phone'      => 'nullable|string|max:30',
            'deal_value' => 'nullable|numeric|min:0',
            'source'     => 'nullable|string|max:100',
            'notes'      => 'nullable|string'
        ];
    }
}
