<?php

namespace App\Http\Requests\FollowUp;

use Illuminate\Foundation\Http\FormRequest;

class StoreFollowUpRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'lead_id'      => 'required|exists:leads,id',
            'scheduled_at' => 'required|date|after_or_equal:now',
            'type'         => 'required|in:call,email,meeting,custom',
            'notes'        => 'nullable|string'
        ];
    }
}
