<?php

namespace App\Http\Middleware;

use Illuminate\Foundation\Http\Middleware\CheckProAccess as Middleware;

class CheckProAccess extends Middleware
{
    /**
     * The URIs that should be excluded from CSRF verification.
     *
     * @var array<int, string>
     */
    protected $except = [
        //
    ];

    public function handle($request, Closure $next)
    {
        if (! $request->user()->hasProAccess()) {
            return response()->json([
                'message' => 'Pro feature locked'
            ], 403);
        }

        return $next($request);
    }
}
