<?php

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TrialController extends Controller
{
    /**
     * Start free trial (one-time only)
     */
    public function start(Request $request)
    {
        $user = $request->user();

        // Trial already used
        if ($user->trial_started_at) {
            return response()->json([
                'message' => 'Trial already used'
            ], 403);
        }

        $user->update([
            'trial_started_at' => now(),
            'trial_ends_at'    => now()->addDays(7),
        ]);

        return response()->json([
            'message' => 'Trial started successfully'
        ]);
    }
}
