<?php

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function profile(Request $request)
    {
        return response()->json([
            'success' => true,
            'data' => $request->user(),
            'error' => null
        ]);
    }

    public function updateProfile(Request $request)
    {
        $request->user()->update(
            $request->validate([
                'name' => 'required|string|max:150',
                'timezone' => 'required|string'
            ])
        );

        return response()->json([
            'success' => true,
            'data' => 'Profile updated',
            'error' => null
        ]);
    }
}
