<?php

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function index(Request $request)
    {
        $notifications = $request->user()
            ->notifications()
            ->latest()
            ->paginate(20);

        return response()->json([
            'success' => true,
            'data' => $notifications->items(),
            'meta' => ['total' => $notifications->total()],
            'error' => null
        ]);
    }

    public function markRead($id)
    {
        auth()->user()->userNotifications()->where('id', $id)
            ->update(['read_at' => now()]);

        return response()->json([
            'success' => true,
            'data' => 'Marked as read',
            'error' => null
        ]);
    }
}
