<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Jobs\DailyFollowUpReminderJob;
use App\Jobs\OverdueFollowUpReminderJob;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Daily reminder for today's follow-ups (morning)
        $schedule->job(new DailyFollowUpReminderJob)
            ->dailyAt('08:00');

        // Hourly reminder for overdue follow-ups
        $schedule->job(new OverdueFollowUpReminderJob)
            ->hourly();

        $schedule->command('trials:expire')->hourly();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
