<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Carbon\Carbon;

class ExpireTrials extends Command
{
    protected $signature = 'trials:expire';
    protected $description = 'Expire trial users';

    public function handle()
    {
        User::whereNotNull('trial_ends_at')
            ->where('trial_ends_at', '<', Carbon::now())
            ->where('subscription_status', '!=', 'active')
            ->update([
                'trial_ends_at' => null
            ]);

        $this->info('Trials expired successfully');
    }
}

